/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.common.util.CSVRecord;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PIVirtualEthernetDataBean
extends PIVirtualSlotDataBean
implements PIDataBeanInterface {
    public static final String KEY_TRUNK = "is_trunk";
    public static final String KEY_IEEE_VIRTUAL_ETHERNET = "ieee_virtual_eth";
    public static final String KEY_PORT_VLAN_ID = "port_vlan_id";
    public static final String KEY_ADDITIONAL_VLAN_IDS = "addl_vlan_ids";
    public static final String KEY_MAC_ADDRESS = "mac_addr";
    public static final short TRUNK = 1;
    public static final short NON_TRUNK = 0;
    public static final short DEFAULT_TRUNK = 0;
    public static final String STRING_NO_TRUNK = "0";
    public static final String STRING_TRUNK = "1";
    public static final short IEEE802_1Q = 1;
    public static final short NON_IEEE = 0;
    public static final String STRING_NO_IEEE = "0";
    public static final String STRING_IEEE = "1";
    public static final short MIN_SLOT_NUMBER = 2;
    public static final short MIN_PORT_VLAN_ID = 1;
    public static final short MIN_ADDL_VLAN_ID = 2;
    public static final short MAX_VLAN_ID = 4094;
    public static final String[] ALL_KEYS = new String[]{"lpar_name", "lpar_id", "slot_num", "state", "ieee_virtual_eth", "port_vlan_id", "addl_vlan_ids", "is_trunk", "is_required", "mac_addr"};
    private UnsignedInt8 m_trunk;
    private UnsignedInt16 m_pvid;
    private UnsignedInt8 m_ieee;
    private UnsignedInt16[] m_additionalVids;
    public String m_macAddress;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public PIVirtualEthernetDataBean() {
        this.m_configurationState = new UnsignedInt8(1);
    }

    public UnsignedInt8 getIeee() {
        return this.m_ieee;
    }

    public UnsignedInt16[] getAdditionalVids() {
        return this.m_additionalVids;
    }

    public UnsignedInt16 getPvid() {
        return this.m_pvid;
    }

    public void setIeee(UnsignedInt8 unsignedInt8) {
        this.m_ieee = unsignedInt8;
    }

    public void setAdditionalVids(UnsignedInt16[] unsignedInt16Array) {
        this.m_additionalVids = unsignedInt16Array;
    }

    public void setPvid(UnsignedInt16 unsignedInt16) {
        this.m_pvid = unsignedInt16;
    }

    public String getAdditionalVidsString() {
        CSVRecord cSVRecord = new CSVRecord(true, ",");
        if (this.m_additionalVids != null) {
            for (int i = 0; i < this.m_additionalVids.length; ++i) {
                cSVRecord.add(this.m_additionalVids[i]);
            }
        }
        return cSVRecord.toString();
    }

    public UnsignedInt8 getTrunk() {
        return this.m_trunk;
    }

    public void setTrunk(UnsignedInt8 unsignedInt8) {
        this.m_trunk = unsignedInt8;
    }

    public String getMacAddress() {
        return this.m_macAddress;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ("lpar_id".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_partitionID, bl);
                continue;
            }
            if ("lpar_name".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_partitionName, bl);
                continue;
            }
            if ("slot_num".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_slotNumber, bl);
                continue;
            }
            if ("config".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, "eth", bl);
                continue;
            }
            if ("state".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeState, bl);
                continue;
            }
            if ("drc_name".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_drcName, bl);
                continue;
            }
            if (KEY_IEEE_VIRTUAL_ETHERNET.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getIeeeString(), bl);
                continue;
            }
            if (KEY_PORT_VLAN_ID.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pvid, bl);
                continue;
            }
            if (KEY_ADDITIONAL_VLAN_IDS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getAdditionalVidsString(), bl);
                continue;
            }
            if ("is_required".equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getIsRequiredString(), bl);
                continue;
            }
            if (KEY_TRUNK.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getTrunkString(), bl);
                continue;
            }
            if (!KEY_MAC_ADDRESS.equals(string2)) continue;
            CSVRecord.append(cSVRecord, string2, this.m_macAddress, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    private String getIeeeString() {
        if (this.m_ieee.shortValue() == 0) {
            return "0";
        }
        return "1";
    }

    private String getTrunkString() {
        if (this.m_trunk == null || this.m_trunk.shortValue() == 0) {
            return "0";
        }
        return "1";
    }

    public String toStringForProf() {
        CSVRecord cSVRecord = new CSVRecord(true, "/");
        cSVRecord.add(this.m_slotNumber);
        cSVRecord.add(this.getIeeeString());
        cSVRecord.add(this.m_pvid);
        cSVRecord.add(this.getAdditionalVidsString());
        cSVRecord.add(this.getTrunkString());
        cSVRecord.add(this.getIsRequiredString());
        return cSVRecord.toString();
    }
}

